/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.MultiFace;

import jemu.core.device.MultiFace.MultifaceDevice;
import jemu.system.cpc.CPC;

public class MultiFace
extends MultifaceDevice {
    public static final byte[] MultifaceRam = new byte[8192];
    protected int Multiface_Flags = 0;
    protected int MULTIFACE_FLAGS_RAM_ENABLED = 1;

    public MultiFace() {
        super("Multiface 2 \u00a91988 by Romantic Robot");
    }

    @Override
    public void writePort(int port, int data) {
        byte PortHighByte;
        if (!CPC.mfisconnected) {
            return;
        }
        if ((port & 0xFFFD) == 65256) {
            this.setRamState((~port & 2) >> 1);
        }
        if ((PortHighByte = (byte)(port >> 8)) == 127) {
            if ((data & 0xC0) == 64) {
                byte PenIndex = MultifaceRam[8143];
                MultiFace.MultifaceRam[0x1F90 | (PenIndex & 0x10) << 2 | PenIndex & 0xF] = (byte)data;
            } else {
                MultiFace.MultifaceRam[0x1FCF | (data & 0xC0) >> 2] = (byte)data;
            }
        }
        if (PortHighByte == -68) {
            MultiFace.MultifaceRam[7423] = (byte)data;
        }
        if (PortHighByte == -67) {
            byte CRTCRegIndex = MultifaceRam[7423];
            MultiFace.MultifaceRam[7600 + (CRTCRegIndex & 0xF)] = (byte)data;
        }
        if (PortHighByte == -9) {
            MultiFace.MultifaceRam[6143] = (byte)data;
        }
        if (PortHighByte == -33) {
            MultiFace.MultifaceRam[6828] = (byte)data;
        }
    }

    protected void setRamState(int RamState) {
        if (RamState != 0) {
            this.Multiface_Flags |= this.MULTIFACE_FLAGS_RAM_ENABLED;
            CPC.memory.setMultiEnabled(true);
        } else {
            this.Multiface_Flags &= ~this.MULTIFACE_FLAGS_RAM_ENABLED;
            if (CPC.memory.multi) {
                CPC.memory.setMultiEnabled(false);
            }
        }
    }
}

